<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersGroupsTable extends Migration {

	public function up()
	{
		Schema::create('customers_groups', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->json('name')->nullable();
			$table->json('description')->nullable();
			$table->string('type', 10)->default('BOTH');
		});
	}

	public function down()
	{
		Schema::drop('customers_groups');
	}
}