<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('total_price')->default('0');
			$table->integer('discount_percent')->default('0');
			$table->bigInteger('discounted_price')->default('0');
			$table->tinyInteger('payment_method');
			$table->string('code', 10);
			$table->tinyInteger('status')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}