<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateComboTable extends Migration {

	public function up()
	{
		Schema::create('combo', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->text('image')->nullable();
			$table->text('description')->nullable();
			$table->text('content')->nullable();
			$table->bigInteger('price');
			$table->tinyInteger('is_discount')->default('0');
			$table->bigInteger('discount_value')->nullable();
			$table->tinyInteger('is_active')->default('1');
			$table->tinyInteger('is_highlight')->default('0');
			$table->tinyInteger('is_new')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('combo');
	}
}