<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMealProvisionTypesTable extends Migration {

	public function up()
	{
		Schema::create('meal_provision_types', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('meal_provision_id')->unsigned()->index();
			$table->integer('meal_type_id')->unsigned()->index();
			$table->tinyInteger('is_default')->unsigned()->index()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('meal_provision_types');
	}
}