<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLocationsTable extends Migration {

	public function up()
	{
		Schema::create('locations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('center_id')->unsigned()->index();
			$table->integer('block_id')->unsigned()->index();
			$table->string('code', 50)->index();
			$table->string('description', 200)->index();
			$table->integer('parent_id')->unsigned()->index();
			$table->integer('location_type_id')->unsigned()->index();
			$table->integer('capacity')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('locations');
	}
}