<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->timestamps();
			$table->softDeletes();
			$table->string('code', 50)->index();
			$table->string('name', 500)->nullable()->index();
			$table->integer('customer_type_id')->unsigned()->nullable()->index();
			$table->tinyInteger('vat_required')->default('0');
			$table->string('vat_number', 50)->nullable()->index();
			$table->tinyInteger('is_key_account')->index()->default('0');
			$table->string('street', 500)->nullable();
			$table->string('housenr', 20)->nullable();
			$table->string('box', 20)->nullable();
			$table->string('postal_code', 50)->nullable();
			$table->string('city', 200)->nullable();
			$table->string('country', 5)->nullable();
			$table->string('invoice_street', 500)->nullable();
			$table->string('invoice_housenr', 20)->nullable();
			$table->string('invoice_box', 20)->nullable();
			$table->string('invoice_postal_code', 50)->nullable();
			$table->string('invoice_city', 200)->nullable();
			$table->string('invoice_country', 5)->nullable();
			$table->string('phone', 50)->nullable();
			$table->string('mobile', 50)->nullable();
			$table->string('email', 200)->nullable();
			$table->string('website', 200)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}