<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConsumptionsTable extends Migration {

	public function up()
	{
		Schema::create('consumptions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('center_id')->unsigned()->index();
			$table->string('description', 200)->index();
			$table->string('unit', 20)->nullable();
			$table->integer('qty_bulk')->default('0');
			$table->string('category', 100);
			$table->integer('sort_order')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('consumptions');
	}
}