<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateActivitiesTable extends Migration {

	public function up()
	{
		Schema::create('activities', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('description', 200)->index();
			$table->tinyInteger('monitor_required')->index()->default('0');
			$table->integer('duration')->unsigned();
			$table->integer('max_people')->default('999');
		});
	}

	public function down()
	{
		Schema::drop('activities');
	}
}