<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserAddressesTable extends Migration {

	public function up()
	{
		Schema::create('user_addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 225);
			$table->string('address');
			$table->string('coordinates');
			$table->double('radius');
			$table->string('notes');
			$table->boolean('is_default');
			$table->integer('user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_addresses');
	}
}