<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWishlistTable extends Migration {

	public function up()
	{
		Schema::create('wishlist', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->uuid('uuid')->unique();
			$table->bigInteger('user_id')->unsigned();
			$table->string('ref_type');
			$table->bigInteger('ref_id')->unsigned();
			$table->string('ref_table');
		});
	}

	public function down()
	{
		Schema::drop('wishlist');
	}
}