<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVariantParametersTable extends Migration {

	public function up()
	{
		Schema::create('variant_parameters', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->uuid('uuid')->unique();
			$table->integer('variant_id')->unsigned()->index();
			$table->string('slug', 63)->index();
			$table->string('value', 127)->index();
			$table->text('remarks')->nullable();
			$table->integer('updated_by')->unsigned()->nullable()->index();
			$table->integer('created_by')->unsigned()->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('variant_parameters');
	}
}