<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->uuid('uuid')->unique();
			$table->timestamp('date')->nullable();
			$table->string('invoice_number')->nullable();
			$table->smallInteger('type')->unsigned();
			$table->text('remarks')->nullable();
			$table->string('ref_table', 127)->nullable();
			$table->string('ref_model', 127)->nullable();
			$table->integer('ref_id')->unsigned()->nullable();
			$table->decimal('amount_previous', 16,2)->nullable();
			$table->decimal('amount', 16,2);
			$table->decimal('amount_final', 16,2);
			$table->char('currency_id', 3);
			$table->integer('status')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}