<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSkinDiariesTable extends Migration {

	public function up()
	{
		Schema::create('skin_diaries', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->unique();
			$table->string('user_id');
			$table->date('date');
			$table->text('description')->nullable();
			$table->timestamps();
			$table->json('custom_properties');
		});
	}

	public function down()
	{
		Schema::drop('skin_diaries');
	}
}