<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->uuid('uuid')->unique();
			$table->integer('group_id')->unsigned()->nullable()->index();
			$table->integer('cart_id')->unsigned()->nullable()->index();
			$table->integer('customer_id')->unsigned()->nullable()->index();
			$table->string('number', 127)->unique()->nullable();
			$table->timestamp('date_issued');
			$table->timestamp('date_paid')->nullable();
			$table->timestamp('date_processed')->nullable();
			$table->timestamp('date_manifested')->nullable();
			$table->timestamp('date_shipped')->nullable();
			$table->timestamp('date_completed')->nullable();
			$table->json('data')->nullable();
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->integer('updated_by')->unsigned()->nullable()->index();
			$table->integer('created_by')->unsigned()->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}