<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFlashsalesTable extends Migration {

	public function up()
	{
		Schema::create('flashsales', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->unique();
			$table->string('title');
			$table->text('description')->nullable();
			$table->boolean('is_enabled')->default(0);
			$table->integer('created_by')->unsigned();
			$table->integer('updated_by')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('flashsales');
	}
}