<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCartsTable extends Migration {

	public function up()
	{
		Schema::create('carts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->uuid('uuid')->unique();
			$table->integer('customer_id')->unsigned()->index();
			$table->boolean('is_current')->index()->default(true);
			$table->string('voucher_code', 63)->nullable()->index();
			$table->integer('payment_method')->unsigned()->nullable()->index();
			$table->json('data')->nullable();
			$table->integer('item_count')->unsigned()->nullable()->index();
			$table->integer('created_by')->unsigned()->nullable()->index();
			$table->integer('updated_by')->unsigned()->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('carts');
	}
}