<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBrandsTable extends Migration {

	public function up()
	{
		Schema::create('brands', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->uuid('uuid')->unique();
			$table->string('title', 127);
			$table->boolean('is_digital')->default(0);
			$table->text('description')->nullable();
			$table->integer('index')->unsigned()->nullable()->index();
			$table->boolean('is_enabled')->index()->default(true);
			$table->boolean('is_featured')->index()->default(false);
			$table->integer('created_by')->unsigned()->nullable()->index();
			$table->integer('updated_by')->unsigned()->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('brands');
	}
}