<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArticlesTable extends Migration {

	public function up()
	{
		Schema::create('articles', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->unique();
			$table->string('title')->index();
			$table->longText('content');
			$table->string('video_url');
			$table->string('status');
			$table->string('author_name');
			$table->datetime('published_at');
			$table->integer('created_by');
			$table->integer('updated_by');
			$table->softDeletes();
			$table->timestamps();
			$table->string('slug');
		});
	}

	public function down()
	{
		Schema::drop('articles');
	}
}