<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArticleCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('article_categories', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('index')->unique()->unsigned();
			$table->string('title');
			$table->text('description')->nullable();
			$table->boolean('is_enabled')->default(false);
			$table->boolean('is_featured')->default(false);
		});
	}

	public function down()
	{
		Schema::drop('article_categories');
	}
}