<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFoldersTable extends Migration {

	public function up()
	{
		Schema::create('folders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255);
			$table->text('description')->nullable();
			$table->integer('thumbnail')->unsigned()->nullable();
			$table->integer('dependency')->unsigned()->nullable();
			$table->boolean('shared')->default(0);
			$table->boolean('access')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('folders');
	}
}