<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Episodes', function(Blueprint $table) {
			$table->foreign('CategoryId')->references('Id')->on('Category')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Episodes', function(Blueprint $table) {
			$table->foreign('ParentId')->references('Id')->on('Episodes')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('Episode_Publisher', function(Blueprint $table) {
			$table->foreign('EpisodeId')->references('Id')->on('Episodes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Episode_Publisher', function(Blueprint $table) {
			$table->foreign('PublisherId')->references('Id')->on('Publishers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Sessions', function(Blueprint $table) {
			$table->foreign('EpisodeId')->references('Id')->on('Episodes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Episode_User', function(Blueprint $table) {
			$table->foreign('UserId')->references('Id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Episode_User', function(Blueprint $table) {
			$table->foreign('EpisodeId')->references('Id')->on('Episodes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Episode_Tag', function(Blueprint $table) {
			$table->foreign('TagId')->references('Id')->on('Tags')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Episode_Tag', function(Blueprint $table) {
			$table->foreign('EpisodeId')->references('Id')->on('Episodes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Baskets', function(Blueprint $table) {
			$table->foreign('UserId')->references('Id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Basket_Episode', function(Blueprint $table) {
			$table->foreign('BasketId')->references('Id')->on('Baskets')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Basket_Episode', function(Blueprint $table) {
			$table->foreign('EpisodeId')->references('Id')->on('Episodes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Comments', function(Blueprint $table) {
			$table->foreign('ParentId')->references('Id')->on('Comments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Comments', function(Blueprint $table) {
			$table->foreign('EpisodeId')->references('Id')->on('Episodes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Discount_Episode', function(Blueprint $table) {
			$table->foreign('EpisodeId')->references('Id')->on('Episodes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Discount_Episode', function(Blueprint $table) {
			$table->foreign('DiscountId')->references('Id')->on('Discounts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Payments', function(Blueprint $table) {
			$table->foreign('UserId')->references('Id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Payments', function(Blueprint $table) {
			$table->foreign('DiscountId')->references('Id')->on('Discounts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Slides', function(Blueprint $table) {
			$table->foreign('SliderId')->references('Id')->on('Sliders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Payment_Episode', function(Blueprint $table) {
			$table->foreign('PayId')->references('Id')->on('Payments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Payment_Episode', function(Blueprint $table) {
			$table->foreign('EpisodeId')->references('Id')->on('Episodes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('Episodes', function(Blueprint $table) {
			$table->dropForeign('Episodes_CategoryId_foreign');
		});
		Schema::table('Episodes', function(Blueprint $table) {
			$table->dropForeign('Episodes_ParentId_foreign');
		});
		Schema::table('Episode_Publisher', function(Blueprint $table) {
			$table->dropForeign('Episode_Publisher_EpisodeId_foreign');
		});
		Schema::table('Episode_Publisher', function(Blueprint $table) {
			$table->dropForeign('Episode_Publisher_PublisherId_foreign');
		});
		Schema::table('Sessions', function(Blueprint $table) {
			$table->dropForeign('Sessions_EpisodeId_foreign');
		});
		Schema::table('Episode_User', function(Blueprint $table) {
			$table->dropForeign('Episode_User_UserId_foreign');
		});
		Schema::table('Episode_User', function(Blueprint $table) {
			$table->dropForeign('Episode_User_EpisodeId_foreign');
		});
		Schema::table('Episode_Tag', function(Blueprint $table) {
			$table->dropForeign('Episode_Tag_TagId_foreign');
		});
		Schema::table('Episode_Tag', function(Blueprint $table) {
			$table->dropForeign('Episode_Tag_EpisodeId_foreign');
		});
		Schema::table('Baskets', function(Blueprint $table) {
			$table->dropForeign('Baskets_UserId_foreign');
		});
		Schema::table('Basket_Episode', function(Blueprint $table) {
			$table->dropForeign('Basket_Episode_BasketId_foreign');
		});
		Schema::table('Basket_Episode', function(Blueprint $table) {
			$table->dropForeign('Basket_Episode_EpisodeId_foreign');
		});
		Schema::table('Comments', function(Blueprint $table) {
			$table->dropForeign('Comments_ParentId_foreign');
		});
		Schema::table('Comments', function(Blueprint $table) {
			$table->dropForeign('Comments_EpisodeId_foreign');
		});
		Schema::table('Discount_Episode', function(Blueprint $table) {
			$table->dropForeign('Discount_Episode_EpisodeId_foreign');
		});
		Schema::table('Discount_Episode', function(Blueprint $table) {
			$table->dropForeign('Discount_Episode_DiscountId_foreign');
		});
		Schema::table('Payments', function(Blueprint $table) {
			$table->dropForeign('Payments_UserId_foreign');
		});
		Schema::table('Payments', function(Blueprint $table) {
			$table->dropForeign('Payments_DiscountId_foreign');
		});
		Schema::table('Slides', function(Blueprint $table) {
			$table->dropForeign('Slides_SliderId_foreign');
		});
		Schema::table('Payment_Episode', function(Blueprint $table) {
			$table->dropForeign('Payment_Episode_PayId_foreign');
		});
		Schema::table('Payment_Episode', function(Blueprint $table) {
			$table->dropForeign('Payment_Episode_EpisodeId_foreign');
		});
	}
}