<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('Payments', function(Blueprint $table) {
			$table->increments('Id', true);
			$table->integer('UserId')->unsigned();
			$table->string('Cost');
			$table->integer('DiscountId')->unsigned();
			$table->string('Transaction_ID');
			$table->timestamp('paid_at')->nullable();
			$table->string('Paid_ID')->nullable();
			$table->timestamps();
			$table->timestamp('updated_at')->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('Payments');
	}
}