<?php

namespace shop.Episode_Publisher;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Episode_Publisher extends Model 
{

    protected $table = 'Episode_Publisher';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('Id', 'EpisodeId', 'PublisherId', 'created_at');

    public function episodes()
    {
        return $this->belongsToMany('Publishers');
    }

    public function publishers()
    {
        return $this->belongsToMany('Episodes');
    }

}