<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function restrictions()
	{
		return $this->hasMany('User');
	}

	public function role()
	{
		return $this->belongsTo('Role', 'user_id');
	}

}