<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLoginAttemptsTable extends Migration {

	public function up()
	{
		Schema::create('login_attempts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id');
			$table->enum('login_status', array('failed', 'succes'));
			$table->string('ip', 30);
			$table->string('browser', 50);
			$table->string('os', 50);
		});
	}

	public function down()
	{
		Schema::drop('login_attempts');
	}
}