<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Question extends Model 
{

    protected $table = 'questions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function type()
    {
        return $this->belongsTo('QuestionType');
    }

    public function answers()
    {
        return $this->hasMany('QuestionAnswer');
    }

    public function answereds()
    {
        return $this->hasMany('QuestionUserAnswer');
    }

    public function belongings()
    {
        return $this->hasMany('Questionable');
    }

}