<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContractStabilitiesTable extends Migration {

	public function up()
	{
		Schema::create('contract_stabilities', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('contract_id')->unsigned()->index();
			$table->datetime('begin_stability_date');
			$table->datetime('end_stability_date');
			$table->timestamps();
			$table->string('reason', 191);
		});
	}

	public function down()
	{
		Schema::drop('contract_stabilities');
	}
}