<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContractSettingsTable extends Migration {

	public function up()
	{
		Schema::create('contract_settings', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('contract_id')->unsigned()->nullable()->index();
			$table->string('name', 191);
			$table->boolean('primary')->default(0);
			$table->date('begin_date');
			$table->date('end_date')->nullable();
			$table->time('night_hours_begin');
			$table->time('night_hours_end');
			$table->decimal('eh_percent_between_0_2', 6,2);
			$table->decimal('eh_percent_between_2_3', 6,2);
			$table->decimal('eh_percent_between_3_4', 6,2);
			$table->decimal('eh_percent_between_4_5', 6,2);
			$table->decimal('eh_percent_more_5', 6,2);
			$table->decimal('eh_percent_restday', 6,2);
			$table->time('limit_hours_day')->nullable();
			$table->time('limit_hours_week')->nullable();
			$table->boolean('work_shift')->default(0);
			$table->time('limit_work_hours_day_in_work_shift')->nullable();
			$table->time('limit_work_hours_week_in_work_shift')->nullable();
			$table->time('rest_after_work_in_shift')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contract_settings');
	}
}