<?php

namespace Merchant\Entities;

class ContractVacation extends Eloquent {

	protected $table = 'contract_vacations';
	public $timestamps = true;
	protected $fillable = array('contract_id', 'begin_acquisition_date', 'end_acquisition_date', 'begin_concession_date', 'end_concession_date', 'enjoyed', 'begin_enjoy_date', 'end_enjoy_date');
	protected $visible = array('contract_id', 'begin_acquisition_date', 'end_acquisition_date', 'begin_concession_date', 'end_concession_date', 'enjoyed', 'begin_enjoy_date', 'end_enjoy_date');

	public function contract()
	{
		return $this->belongsTo('EmployeeContract', 'contract_id', 'id');
	}

}