<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('phone');
			$table->string('email');
			$table->string('pin_code')->nullable();
			$table->date('d_o_b');
			$table->integer('blood_type_id')->unsigned();
			$table->date('last_donation_data');
			$table->integer('city_id')->unsigned();
			$table->string('password');
			$table->string('access_token', 60)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}