<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReviewsTable extends Migration {

	public function up()
	{
		Schema::create('reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->string('user_ip', 45);
			$table->integer('product_id');
			$table->decimal('price', 15,2);
			$table->double('discounted_price', 15,2);
			$table->string('site_origin', 255);
			$table->string('search_origin', 45);
			$table->timestamps();
			$table->integer('total_reviews');
			$table->double('original_ratting', 5,2);
			$table->integer('reviewers');
			$table->integer('removed_reviewers');
			$table->double('ratting', 5,2);
		});
	}

	public function down()
	{
		Schema::drop('reviews');
	}
}