<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DeliveryInternal extends Model 
{

    protected $table = 'delivery_internal';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('store_id', 'level_id', 'price');

    public function store()
    {
        return $this->belongsTo('Store', 'store_id');
    }

    public function level()
    {
        return $this->belongsTo('DeliveryLevel', 'level_id');
    }

}