<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Schedule extends Model 
{

    protected $table = 'schedule';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('from_hour', 'to_hour', 'day_off', 'store_id');

    public function store()
    {
        return $this->belongsTo('Store', 'store_id');
    }

}