<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderOption extends Model 
{

    protected $table = 'order_option';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('order_product_id', 'option_id', 'price');

    public function product()
    {
        return $this->belongsTo('OrderProduct', 'order_product_id');
    }

    public function option()
    {
        return $this->belongsTo('Option', 'option_id');
    }

}