<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTaskFieldTemplatesTable extends Migration {

	public function up()
	{
		Schema::create('task_field_templates', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('task_field_type');
			$table->bigInteger('task_type_id')->unsigned();
			$table->integer('order')->unsigned();
			$table->bigInteger('parent_id')->unsigned();
			$table->string('name')->nullable();
			$table->boolean('is_required')->default(true);
			$table->json('properties')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('task_field_templates');
	}
}