<?php

namespace Forums\Data;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Post extends Eloquent {

	protected $table = 'posts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('conversation_id', 'user_id', 'content');

	public function conversation()
	{
		return $this->belongsTo('Conversation');
	}

	public function author()
	{
		return $this->belongsTo('User');
	}

}