<?php

namespace Forums\Data;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Conversation extends Eloquent {

	protected $table = 'conversations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('channel_id', 'user_id', 'title', 'slug', 'answer_id');

	public function channel()
	{
		return $this->belongsTo('Channel');
	}

	public function posts()
	{
		return $this->hasMany('Post');
	}

	public function author()
	{
		return $this->belongsTo('User');
	}

	public function conversationStates()
	{
		return $this->hasMany('ConversationState');
	}

	public function notifications()
	{
		return $this->hasManyThrough('User', 'Notification');
	}

}