<?php

namespace Forums\Data;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Channel extends Eloquent {

	protected $table = 'channels';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'slug', 'color', 'icon');

	public function conversations()
	{
		return $this->hasMany('Conversation');
	}

}