<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserPack extends Model 
{

    protected $table = 'user_packs';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user_group()
    {
        return $this->belongsTo('UserGroup');
    }

    public function users()
    {
        return $this->morphMany('User', 'usable');
    }

    public function pack_type()
    {
        return $this->belongsTo('PackType');
    }

}