<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PegSection extends Model 
{

    protected $table = 'peg_sections';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function peg()
    {
        return $this->belongsTo('Peg');
    }

    public function related()
    {
        return $this->belongsToMany('PegSection', 'related_section', 'base_id', 'related_id');
    }

    public function peg_objects()
    {
        return $this->hasMany('PegObject');
    }

}