<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UserGroup extends Eloquent {

	protected $table = 'user_groups';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user_section()
	{
		return $this->belongsTo('UserSection');
	}

	public function users()
	{
		return $this->morphMany('User', 'usable');
	}

}