<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PegSection extends Eloquent {

	protected $table = 'peg_sections';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function peg()
	{
		return $this->belongsTo('Peg');
	}

	public function related()
	{
		return $this->belongsToMany('PegSection', 'related_section', 'base_id', 'related_id');
	}

	public function peg_objects()
	{
		return $this->hasMany('PegObject');
	}

}