<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('sites', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('sites')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->foreign('user_id')->references('current_team_id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('event_types', function(Blueprint $table) {
			$table->foreign('site_id')->references('id')->on('sites')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->foreign('site_id')->references('id')->on('sites')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('event_type_urls', function(Blueprint $table) {
			$table->foreign('event_type_id')->references('id')->on('event_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('event_type_id')->references('id')->on('event_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('campaign_event_types', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaigns')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('campaign_event_types', function(Blueprint $table) {
			$table->foreign('event_type_id')->references('id')->on('event_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('sites', function(Blueprint $table) {
			$table->dropForeign('sites_team_id_foreign');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->dropForeign('teams_user_id_foreign');
		});
		Schema::table('event_types', function(Blueprint $table) {
			$table->dropForeign('event_types_site_id_foreign');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->dropForeign('campaigns_site_id_foreign');
		});
		Schema::table('event_type_urls', function(Blueprint $table) {
			$table->dropForeign('event_type_urls_event_type_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_event_type_id_foreign');
		});
		Schema::table('campaign_event_types', function(Blueprint $table) {
			$table->dropForeign('campaign_event_types_campaign_id_foreign');
		});
		Schema::table('campaign_event_types', function(Blueprint $table) {
			$table->dropForeign('campaign_event_types_event_type_id_foreign');
		});
	}
}