<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Campaign extends Eloquent {

	protected $table = 'campaigns';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function site()
	{
		return $this->belongsTo('Site');
	}

	public function eventTypes()
	{
		return $this->belongsToMany('CampaignEventType');
	}

}