<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminTable extends Migration {

	public function up()
	{
		Schema::create('admin', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('mail_id', 255);
			$table->string('password', 255);
			$table->string('number', 255);
			$table->enum('status_flag', array(''));
			$table->string('otp', 255);
			$table->string('otp_time', 255);
			$table->string('isVerified', 255);
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('admin');
	}
}