<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHandOverTable extends Migration {

	public function up()
	{
		Schema::create('hand_over', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('employee_id')->nullable();
			$table->integer('supervisor_id')->nullable();
			$table->double('amount')->nullable();
			$table->enum('status', array('new', 'requested', 'confirmed'))->nullable();
			$table->integer('mall_id')->nullable();
			$table->integer('country_id')->nullable();
			$table->datetime('confirmed_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('hand_over');
	}
}