<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MallStock extends Model 
{

    protected $table = 'mall_stock';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('country_id', 'mall_id', 'supply_id', 'total_quantity', 'out_quantity', 'damaged_qunatity');

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function mall()
    {
        return $this->belongsTo('Mall', 'mall_id');
    }

    public function supply()
    {
        return $this->belongsTo('Supply', 'supply_id');
    }

}