<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('firstname', 50);
			$table->string('lastname', 50);
			$table->string('username', 50)->unique()->nullable();
			$table->string('email', 100)->unique();
			$table->boolean('private')->default(0);
			$table->date('birthday')->nullable();
			$table->boolean('sex')->default(0);
			$table->string('phone', 20)->nullable();
			$table->string('bio', 140)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}