<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRolesTable extends Migration {

	public function up()
	{
		Schema::create('roles', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('company_id')->unsigned();
			$table->bigInteger('company_division_id')->unsigned();
			$table->string('name');
			$table->string('slug');
			$table->string('description');
			$table->string('position');
			$table->smallInteger('level');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('roles');
	}
}