<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlanSubscriptionsTable extends Migration {

	public function up()
	{
		Schema::create('plan_subscriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('agent_id')->unsigned();
			$table->bigInteger('plan_is')->unsigned();
			$table->string('slug');
			$table->string('name');
			$table->json('description');
			$table->string('trial_ends_at');
			$table->string('starts_at');
			$table->string('ends_at');
			$table->string('cancels_at');
			$table->string('canceled_at');
			$table->string('timezone');
		});
	}

	public function down()
	{
		Schema::drop('plan_subscriptions');
	}
}